/**
Status - Bibliothek für HeatBoxNG
Ein OOP-Ansatz zur besseren und einfacheren Behandlung der
im System auftretenen Betriebszustände, Fehler und Warnungen
**/

/**========================= Systemstatusobjekt =======================**/
/*
 Das Objekt speichert alle zum Status gehörigen Werte (anzuzeigene Bitmap, Piepscode, LED-Blinkcode).
 Die Ausgabe muss also nur das aktuelle Element nach den für sich bestimmten Wert fragen.
*/


class Status {
  private:
    uint8_t* _symbol;
    byte _piepcode;
    byte _blinkcode;
    Status* _next;
  
  public:
    uint8_t* getSymbol();
    byte getPiepcode();
    byte getBlinkcode();
    Status* getNext();
    void setNext(Status*);
    Status(uint8_t*,byte,byte);
};


Status::Status(uint8_t* symbol, byte piepcode, byte blinkcode):   //Konstruktor
    _symbol(NULL),
    _piepcode(0),
    _blinkcode(0),
    _next(NULL)
{
  _symbol = symbol;
  _piepcode = piepcode;
  _blinkcode = blinkcode; 
}


uint8_t* Status::getSymbol(){
  return _symbol;
}

byte Status::getPiepcode(){
  return _piepcode;
}

byte Status::getBlinkcode() {
  return _blinkcode;
};
Status* Status::getNext() {
  return _next;
};
  
void Status::setNext(Status* n){
  _next = n;
};



/**================= Selbstrotierende LinkedList - Speichert Statuswerte =====================**/
/*
Idee:
  Alle aufkommenden Fehler werden hier gespeichert und rotierend abgefragt.
  So muss sich sonst niemand drum kümmern welcher der Fehler gerade angezeigt werden muss
  oder wie viele es gibt.
  Die Liste kümmert sich darum.
  Einzige Begrenzung ist der RAM, ansonsten können "unendlich" viele Fehler gespeichert werden
*/


class Queue {
  private:
    Status* _current;
    int _length;
  
  public:
    void add(byte);
    int length();
    Status* get();
    Queue();
};

Queue::Queue():        //Konstruktor
  _current(NULL),
  _length(0)
  {
    
  }


int Queue::length() {
  return _length;
}

void Queue::add(byte error) {
  Status *e;
  e = new Status(NULL,error,0);
  if(_length == 0) {
   
  } else {
   e->setNext(_current); 
  }
  _current = e;
  _length++;
};


Status* Queue::get(){
  if(_current==NULL) return NULL;
  Status* temp = _current;

  while((temp->getNext())!=NULL){
   temp=temp->getNext();
  }
  temp->setNext(_current);          //Erstes Element hinten an Liste angängen
  _current=_current->getNext();     //Zweites Element zum Ersten machen
  temp->getNext()->setNext(NULL);   //Nachfolger des jetzt letzten Elementes auf NULL setzen
  return _current;
}


extern Queue q;
Queue q = Queue();
