
void screen_main(){
//links
  glcd.drawstring( 0 , 0, spaditoa(sensorValues.mah,5));
  glcd.drawbitmap( 30, 2, mah_bitmap, 13, 5, BLACK);
  glcd.drawstring( 0 ,12, spaditoa(sensorValues.voltage/10,2));
  
  glcd.drawstring( 11, 12,  ".");
  glcd.drawstring( 16, 12,  paditoa(sensorValues.voltage%10,1));
  glcd.drawstring( 23, 12,  "V");
  
//mitte
  glcd.drawbitmap( 52, 0, symbol, 24, 24,BLACK);
  
//rechts
  glcd.drawbitmap( 90,  0, get_bigfont((int)sensorValues.temperature/1000), 8, 12,BLACK);
  glcd.drawbitmap( 99,  0, get_bigfont((int)(sensorValues.temperature%1000)/100), 8, 12,BLACK);
  glcd.drawbitmap( 108, 10, bullet, 2, 2,BLACK);
  glcd.drawbitmap( 111, 0, get_bigfont((int)((sensorValues.temperature%1000)%100)/10), 8, 12,BLACK);
  
  glcd.drawbitmap( 120, 0,  gc_bitmap, 7, 7, BLACK);
  glcd.drawstring( 108, 15, paditoa(settings.max_temp,2));
  glcd.drawbitmap( 120, 15, gc_bitmap, 7, 7, BLACK);

//unten
  if((sysStatus&syst_externeQuelle)>0) {
    glcd.drawbitmap( 40, 26, extquelle_bitmap, 47, 5, BLACK);
  } else {
    glcd.drawstring(0, 24, spaditoa(sensorValues.percent,3));
    glcd.drawchar( 19, 24, '%');
    glcd.drawrect( 28, 26, 100,6,BLACK);
    glcd.fillrect( 28, 26, sensorValues.percent,6,BLACK);
  }
}

//--------------------------------------------------------------------------------

void screen_info(){
  glcd.drawstring(  0, 1,  "SW-Version:");
  glcd.drawchar(   80, 1,  (48+version[0]));
  glcd.drawstring( 85, 1,  "."); 
  glcd.drawchar(   90, 1,  (48+version[1]));
  glcd.drawstring( 95, 1,  "."); 
  glcd.drawchar(  100, 1,  (48+version[2]));

  glcd.drawstring(0, 11,   "HW-Version:");
  glcd.drawstring(80, 11,  "1"); 
  
  glcd.drawstring(60,  24, "ok");
}

//--------------------------------------------------------------------------------

void screen_holdReset(byte steps){
  glcd.drawstring(50, 1,  "Reset Akku");
  glcd.invertrect(0, 0 ,128 ,10);
  glcd.drawrect(14, 20, 100, 6, BLACK);
  glcd.fillrect(14, 20, steps, 6, BLACK);
}

//--------------------------------------------------------------------------------

void screen_akkuReset(){
  glcd.drawstring(50, 1,  "Reset Akku");
  glcd.invertrect(0, 0 ,128 ,10);
  glcd.drawstring(30, 12,  "Verbrauch");
  glcd.drawstring(20, 24,  "zurueckgesetzt");
}

//--------------------------------------------------------------------------------

void screen_menu(char* text){
  glcd.drawstring(50, 1,  "Menue");
  glcd.invertrect(0 , 0 ,128 ,10);
  glcd.drawstring((uint8_t)(64-((strlen(text)/2)*7)), 13,  text);
  glcd.drawbitmap(0 , 27, arr_left, 6, 5, BLACK);
  glcd.drawstring(60,  24,  "ok");
  glcd.drawbitmap(121, 27, arr_right, 6, 5, BLACK);
}

//--------------------------------------------------------------------------------

void subscreen_sheader(char* s){
  glcd.drawstring(11, 1,  s);
  glcd.invertrect(0 , 0, 128 ,10);
}

//--------------------------------------------------------------------------------

void subscreen_sfooter(){
  glcd.drawstring(0,  24,  "-");
  glcd.drawbitmap(60, 27, arr_right, 6, 5, BLACK);
  glcd.drawstring(121, 24,  "+");
}

//--------------------------------------------------------------------------------

void subscreen_printTempValue(uint8_t val){
  glcd.drawstring(57, 15, spaditoa(val,2));
  glcd.drawbitmap(70, 15, gc_bitmap, 7, 7, BLACK);
}

//--------------------------------------------------------------------------------

void subscreen_printCapaValue(unsigned int val){
  glcd.drawstring(48, 15,  spaditoa(val,5));
  glcd.drawbitmap(80, 17,  mah_bitmap, 13, 5, BLACK);
}

//--------------------------------------------------------------------------------

void subscreen_printTimeValue(uint8_t val){
  glcd.drawstring(55, 15,  spaditoa(val,3));
  glcd.drawbitmap(76, 17,  sek_bitmap, 11, 5, BLACK);
}

void subscreen_printDefaultValue(uint8_t val){
  glcd.drawstring(55, 15,  spaditoa(val,3));
}

//--------------------------------------------------------------------------------

void screen_smaxtemp(){
  subscreen_sheader("Zieltemperatur");
  subscreen_printTempValue(temp_settings.max_temp);
  subscreen_sfooter();
}
//--------------------------------------------------------------------------------

void screen_shyster(){
  subscreen_sheader("Hyterese");
  subscreen_printTempValue(temp_settings.hysterese);
  subscreen_sfooter();
}

//--------------------------------------------------------------------------------

void screen_sakkutype(){
  subscreen_sheader("Akkutyp");
  glcd.drawstring(52, 15, akku_names[temp_settings.akku_type]);
  subscreen_sfooter();
}

//--------------------------------------------------------------------------------

void screen_sakkucapa(){
  subscreen_sheader("Akkukapazitaet");
  subscreen_printCapaValue(temp_settings.akku_size);
  subscreen_sfooter();
}

//--------------------------------------------------------------------------------

void screen_sakkucut(){
  subscreen_sheader("Abschaltgrenze");
  subscreen_printCapaValue(temp_settings.akku_cut);
  subscreen_sfooter();
}

//--------------------------------------------------------------------------------

void screen_sakkudowarn(){
  subscreen_sheader("Zus. Akku-Warnung");
  glcd.drawstring(52, 15, temp_settings.do_akkuwarn?"Ja":"Nein");
  subscreen_sfooter();
}

//--------------------------------------------------------------------------------

void screen_sakkuwarn(){
  subscreen_sheader("Akkuwarnschwelle");
  subscreen_printCapaValue(temp_settings.akku_warn);
  subscreen_sfooter();
}

//--------------------------------------------------------------------------------

void screen_sheatpause(){
  subscreen_sheader("Heizpause Abstand");
  subscreen_printTimeValue(temp_settings.heat_pause);
  subscreen_sfooter();
}

//--------------------------------------------------------------------------------

void screen_sheatpauseduration(){
  subscreen_sheader("Heizpause Dauer");
  subscreen_printTimeValue(temp_settings.heat_pauseduration);
  subscreen_sfooter();
}

//--------------------------------------------------------------------------------

void screen_sfanduration(){
  subscreen_sheader("Ventilatorlaufzeit");
  subscreen_printTimeValue(temp_settings.fan_duration);
  subscreen_sfooter();
}

//--------------------------------------------------------------------------------

void screen_sfanpause(){
  subscreen_sheader("Ventilatorpause");
  subscreen_printTimeValue(temp_settings.fan_pause);
  subscreen_sfooter();
}

//--------------------------------------------------------------------------------

void screen_ssetbacklight(){
  subscreen_sheader("Displaybeleuchtung");
  subscreen_printDefaultValue(temp_settings.backlight);
  subscreen_sfooter();
}

//--------------------------------------------------------------------------------
/*
void screen_ssetcontrast(){
  subscreen_sheader("Display-Kontrast");
  subscreen_printDefaultValue(temp_settings.contrast);
  subscreen_sfooter();
}
*/
//--------------------------------------------------------------------------------

void screen_sstoreeprom(){
  subscreen_sheader("Verbrauch merken?");
  glcd.drawstring(52, 15, temp_settings.storeEEPROM?"Ja":"Nein");
  subscreen_sfooter();
}

//--------------------------------------------------------------------------------

void screen_ssavesettings(){
  subscreen_sheader("Setup speichern?");
  glcd.drawstring(52, 15, save_settings?"Ja":"Nein");
  subscreen_sfooter();
}

//--------------------------------------------------------------------------------

void screen_settingsSaved(){
  glcd.drawstring(52, 15, "gespeichert");
}

//--------------------------------------------------------------------------------
