/*
* HeatBoxNG
* Developement Stage
*
* (c) HaDi-RC
*
*/

//#define NO_PORTC_PINCHANGES
//#define NO_PORTD_PINCHANGES
//#define NO_PORTJ_PINCHANGES
//#define NO_PORTK_PINCHANGES
//#include <PinChangeInt.h>

#include <uc1601.h>
#include <OneWire.h>
#include <avr/eeprom.h>


#include "Settings.h"                     //Einstellungen, DEFINES
#include "Bitmaps.h"                      //Bitmaps
#include "Tempsensor.h"                   //Temperatursensoren
#include "Structs.h"                      //Datenstrukturen

//UC1601 glcd(8, 6, 12, 30);                //SID, SCLK, A0, RST   -    Colins Steckbrett
UC1601 glcd(4,12,6,31);                //SID, SCLK, A0, RST        -    Prototyp

Tempsensor tsensor(pin_wirebus);          //

unsigned int state = state_default;       //Betriebsstatus - erhält den Default-Wert beim Starten
unsigned long mahHighRes =0;              //Speichert den Verbrauch (Kapazität) nicht in mAh, sondern in mA / 10stel Sekunden
unsigned long last_loop_display=0;        //
unsigned long last_loop_sensors=0;        //
unsigned long last_loop_writeCapa=0;      //Wann wurde das letzte mal die Kapazität in den EEPROM geschrieben
unsigned long last_currentcheck=0;        //Zeit seit letzter Strom-Messung (Zeitdifferenz zum Berechnen der entnommenen Kapazität)
unsigned long last_heatpause=0;           //Zeitpunkt der letzten Heizpause
unsigned long intervall=1;                //Errechnete Zeitdifferenz zwischen zwei Strom-Messungen
unsigned long last_handler_call=0;

boolean save_settings=false;              //Im Setup-Menü genutzt. Wenn TRUE wird beim Beenden das settings-struct gespeichert
unsigned int adval = 0;                   //Variable benutzt für das Oversampling des ADC

volatile unsigned long bounceTime=0;      //Zeitpunkt des ersten Auftreten eines IRQ - bis ablauf der Debounce-Zeit wird kein Knopfdruck behandelt
volatile boolean buttonIsPressed=false;   //wird TRUE wenn ein Button gedrückt wird
volatile byte currentButton=0;            //welcher Knopf wurde gedrückt

byte sysStatus=0;                         //Bitmuster für den Systemstatus
byte errStatus=0;                         //Bitmuster für die Fehler und Warnungen
byte heatStatus=0;                        //Bitmuster für den Heizungsstatus

uint8_t* symbol;                          //Pointer auf das zu verwendene Symbol in der Übersicht
byte multibleErrors = 0;                  //gibt es mehrere Fehler die dargestellt werden müssen merkt sich die Variable den zuletzt dargestellten
struct settings_t temp_settings;          //Datenstruktur für die Settings

  
  
//--------------------------------------------------------------------------------

void setup(){
  glcd.begin();                                            //
  glcd.display();                                              //Puffer anzeigen. Der Puffer im Treiber erhält als initialwert das HaDi-RC Logo
  Serial.begin(9600);
  //while (!Serial) {
  //  ; // wait for serial port to connect. Needed for Leonardo only
  //}
  //Serial.println("HBI");
  pinMode(pin_heizung,OUTPUT);
  pinMode(pin_gesamtspannung,INPUT);
  pinMode(pin_stromsensor,INPUT);
  pinMode(pin_backgroundled,OUTPUT);
  pinMode(pin_intext,INPUT);
  pinMode(pin_left,  INPUT); digitalWrite(pin_left,  HIGH);
  pinMode(pin_right, INPUT); digitalWrite(pin_right, HIGH);
  pinMode(pin_enter, INPUT); digitalWrite(pin_enter, HIGH);
  
  //attachInterrupt(1, isr_button0, CHANGE);    //Rechter Button
  //attachInterrupt(3, isr_button1, CHANGE);    //Enter Button
  //attachInterrupt(2, isr_button2, CHANGE);    //Enter Button
    
  attachInterrupt(1, isr_button0, CHANGE);    //Linker Button
  attachInterrupt(3, isr_button2, CHANGE);    //Rechter Button
  attachInterrupt(2, isr_button1, CHANGE);    //Enter Button

  //tsens_errno = tsensor.getErrors();  //eventuelle Fehlernummern aus der Tempsensor-Bibliothek holen
  //tsensor.getTemp();//Zur Initialisierung einmal die Temperatur lesen und Wert verwerfen
  eepromReadSettings();


  if(check_firstrun()){
    /* Die HeatBox wurde vermutlich zum ersten mal gestartet. Wir müssen deshalb
     * zum Ersten Mal die Settings-Struktur aus den presets generieren und im EEPRom ablegen
     */
     reset_settings();
  }
  
  if(check_update()){
     /* Es wurde vermutlich ein Update installiert in dem der Wert für "settings_version" verändert wurde und nicht dem
      * in der EEPRom-Struktur "settings" entspricht. Vermutlich soll die EEPRom-Struktur neu erstellt werden da es Änderungen
      * für die Struktor gab.
      */
      
      //ToDo: Display-Anzeige die den Reset darstellt
      reset_settings();
  }
  
  if(analogRead(pin_intext) >= intextMinRead) {
    /* Wenn am Messpin für die Intern-/Extern-Kennung ein Wert anliegt, der gleich oder höher von "intextMinRead" ist,
     * wird das System in den Modus für "Externe Versorgung" gestellt.
     */ 
     sysStatus |= syst_externeQuelle;
  } else {
    readCapaOffset();
    readCapa();
    writeCapaOffset();         //neues Offset generieren und merken. Alle speichervorgänge während diesem Betriebszyklus werden an die neue Adresse gespeichert.
  }
  
  
  symbol = (uint8_t*)pause_bitmap;
  temp_settings = settings; //erstelle eine Kopie der Settings (für das Setup - damit beim Rumstellen im Setup nicht sofort Alarme ausgelöst werden)
  beep(0);
  analogWrite(pin_backgroundled,display_backlight_values[settings.backlight]);
  delay(500);
  glcd.clear();
  
}


//--------------------------------------------------------------------------------


void beep(byte what){
  switch(what){
    case 0:  tone(pin_buzzer, 700, 50);   break;
    case 1:  tone(pin_buzzer, 1200, 50);  break;
    default: tone(pin_buzzer, 1000, 80);
  }
}

//--------------------------------------------------------------------------------


boolean check_firstrun() {
  //Prüft, ob das System zum allerersten Mal gestartet wurde.
  //Da vor dem ersten Start das EEPROM noch leer ist müssen hier erstmalig die Werte reingeschrieben werden
  return (settings.firstrun == 0) ;          //da noch kein Wert im EEPROM steht haben die Variablen einen Standartwert ("0")
}


//--------------------------------------------------------------------------------


void reset_settings() {
    //Stellt die Standart-Werte wieder her
    settings.max_temp               = preset_max_temp;
    settings.hysterese              = preset_hysterese; 
    settings.akku_type              = preset_akku_type;
    settings.akku_size              = preset_akku_size;
    settings.akku_cut               = preset_akku_cut;
    settings.do_akkuwarn            = preset_do_akkuwarn;
    settings.akku_warn              = preset_akku_warn;
    settings.heat_pause             = preset_heat_pause;
    settings.heat_pauseduration     = preset_heat_pauseduration;
    settings.fan_duration           = preset_fan_duration;
    settings.fan_pause              = preset_fan_pause;
    settings.storeEEPROM            = preset_storeCapa;
    settings.setversion             = settings_version;
    settings.backlight              = preset_backlight;
    //settings.contrast               = preset_contrast;
    settings.firstrun               = 1;
    
    eepromWriteSettings();  //Werte in das EEPROM schreiben
}


//--------------------------------------------------------------------------------


boolean check_update() {          //Prüft, ob die Version des EEPROM-Konstruktes neu ist, wenn ja, wird das EEPROM vorher gelöscht
  return(settings_version!=settings.setversion);
}


//--------------------------------------------------------------------------------

String spaditoa(unsigned long num, byte len){
  //space-padded itoa
  return _paditoa(num,len,' ');
}

String paditoa(unsigned long num, byte len){
  //zero-padded itoa
  return _paditoa(num,len,'0');
}

String _paditoa(unsigned long num, byte len, char c){
 /* Wandelt num in einen String um und füllt ihn mit den Zeichen in c auf
  *
  */
 String t = String(num);
 while(t.length() < len) {t= c+t;}
 return t;
}


//--------------------------------------------------------------------------------


void loop(){
  if( (last_loop_sensors+loop_intervall_sensors) <= millis() ) {  //!!1!!!!T-Sensor-Bibliothek ist zu lahm - lahmer als das Intervall!!!!!
   /* Die Sensoren werden in bestimmten Zeitabständen abgefragt. Sie bei jedem 
    * loop abzufragen wäre unnötig denn die meisten Sensoren können sowieso
    * nicht so schnell messen und anzeigen werden wir es auch nicht so schnell.
    */
   ledloop();
   getTemp();
   readVoltage();
   getmah();
   checkForErrors();
   togglePause();                    //Pausen Bit in gewissen Zeitabständen hin und her schalten
   handleHeating();                  //Heizungs-Ausgang ansteuern
   displayStatus();                  //Symbol in der Mitte der Hauptanzeige entsprechent der Statis anzeigen und Warntöne ausgeben
   last_loop_sensors=millis();
  }
  if((sysStatus && syst_externeQuelle)==0) {  //Versorgung nicht Intern
    if( (last_loop_writeCapa+loop_intervall_writeCapa) <= millis() ) {
      writeCapa();
      Serial.println("Schreibe Capa aufgrund Intervall");
      last_loop_writeCapa = millis();
    }
  }  
    
  /* Die Darstellung am Display wird alle xxx Millisekunden stattfinden. Hierbei unterscheiden wir ob wir die Übersicht anzeigen
   * oder im Menü sind. Im letzteren Falle wollen wir ein etwas schnelleres Intervall um das Wechseln der Menüs auch schnell am Display
   * anzeigen zu können.
   */
  if( (state==state_default && last_loop_display+loop_intervall_default <= millis()) ||
      (state>state_default  && last_loop_display+loop_intervall_menu <= millis())
    ) {
     draw(); // rebuild the picture after some delay
     last_loop_display=millis();
   }
   
   if(buttonIsPressed && bounceTime+longPressDelay<millis()){      //Wurde der Knopf gedrückt und eine gewisse Zeit lang gehalten?
       if(last_handler_call+handler_call_delay<millis()) {
         buttonHandler(true,true);
         last_handler_call=millis();
       }
   }    
}


//--------------------------------------------------------------------------------

void handleHeating(){
  if(heatStatus == heizung_an) {
      digitalWrite(pin_heizung, HIGH);
  }else{
      digitalWrite(pin_heizung, LOW);
  }
}

//--------------------------------------------------------------------------------

void togglePause(){
  if((heatStatus && heizung_konvektion) == 0){              //pausen-bit nicht gesetzt
    if(last_heatpause+(settings.heat_pause*1000) < millis()){
      heatStatus |= heizung_konvektion;
      last_heatpause = millis();
    } 
    else {};
  } else{
     if(last_heatpause+(settings.heat_pauseduration*1000) < millis()){
       heatStatus ^= heizung_konvektion;
        heatStatus |= heizung_an;
       last_heatpause = millis();
     }
  }
}


//--------------------------------------------------------------------------------


void displayStatus(){
 /* Zeigt das für den aktuellen Status entsprechende Symbol an
  * Bei Warnungen und Fehler wird zusätzlich ein entsprechender Warnton ausgegeben
  */
  
  
 //byte sysStatus=0;                         //Bitmuster für den Systemstatus
 //byte errStatus=0;                         //Bitmuster für die Fehler und Warnungen
 //byte heatStatus=0;                        //Bitmuster für den Heizungsstatus
  
  
  //ToDo: was ist, wenn mehrere Fehler auftauchen?
  /*
   Wie viele Kombinationen gibt es dennn?
   
   Heizen + Warnung
   (Konvektions-)Pause + Warnung
   (Zieltemp erreicht-)Pause + Warnung
   Akku Leer + Spannung
   (Akku Warn + Volt  -> ungültig, Volt überragt und schaltet ab )
   (kein TSensor + kein Heizelement -> ungültig, T-Sensor käme zuerst und sparrt das System sowieso)
  */

  //nutze  multibleErrors  
  if(errStatus == fehler_keiner) {
    if( heatStatus == heizung_an ) {
      symbol = (uint8_t*)heizen_bitmap;
    }
     
    else if( (heatStatus&&heizung_hyterese>0) || (heatStatus&&heizung_konvektion>0)) {
      symbol = (uint8_t*)pause_bitmap;
    }
    
  }    

      
  if(errStatus == fehler_AkkuLeer) {
      symbol = (uint8_t*)mahlow_bitmap; 
  }
      
  if(errStatus == fehler_AkkuSpannung) {
      symbol = (uint8_t*)voltlow_bitmap;
  }   
      
 
  if(errStatus == fehler_AkkuSpannung + fehler_AkkuLeer) {
      symbol = multibleErrors==0?(uint8_t*)mahlow_bitmap:(uint8_t*)voltlow_bitmap;
      if(multibleErrors++ >1) multibleErrors=0;
  }
  
  if(errStatus == fehler_AkkuWarnung){
    if(heatStatus == heizung_an) {
      symbol = multibleErrors==0?(uint8_t*)heizen_bitmap:(uint8_t*)mahlow_bitmap;
      if(multibleErrors++ >1) multibleErrors=0;
    }
    if(heatStatus == heizung_hyterese || heatStatus == heizung_konvektion) {
      symbol = multibleErrors==0?(uint8_t*)pause_bitmap:(uint8_t*)mahlow_bitmap;
      if(multibleErrors++ >1) multibleErrors=0;
    }
  }
  
  
}
      



//--------------------------------------------------------------------------------


void ledloop(){
 /* Stellt den Betriebsstatus auf der LED dar
  * schnelles Blinken = booten
  * Dauerleuchten = Betriebsbereit
  * Langsames Blinken = Heizen
  * Blinken mit Pausen = Fehler
  */ 
  
  //ToDo:
}

//--------------------------------------------------------------------------------

void checkForErrors(){
  /* Wir prüfen alle Sensorwerte auf ihre Gültigkeit bzw. ihren Wert
   * und setzen ggf ei entsprechendes Bit im Fehler-Byte
   */
   if((sysStatus&syst_externeQuelle)==0) {  //Prüfen, ob wir mit der internen Quelle versorgt werden
    if(sensorValues.mah >= settings.akku_size) {                        //Akku leer (Angegebene Kapazität überschritten)
      errStatus |= fehler_AkkuLeer;              //Fehlerbit setzen
      heatStatus = heizung_gesperrt;             //Alle Heizungsbits löschen und Sperrbit setzen
    }
    if(sensorValues.voltage < akku_volts[settings.akku_type]) {         //Akkuspannung zu gering (Spannung ist kleiner als der Mindestwert des ausgewählten Akkutyps)
      errStatus |= fehler_AkkuSpannung;          //Fehlerbit setzen
      heatStatus = heizung_gesperrt;             //Alle Heizungsbits löschen und Sperrbit setzen 
    }
  } //if intern
}


//--------------------------------------------------------------------------------


void getTemp(){
  /* Ließt die Temperatur aus den Sensor-Modul und prüft grob auf Gültigkeit.
   */
  int t =  tsensor.getTemp();
  if(t<0 || t>10000) t==0;
  sensorValues.temperature = t;
}


//--------------------------------------------------------------------------------


void getmah(){

  /* Versuch der Erhöhung der ADC-Auflösung auf 11 Bit
   * durch Oversampling nach der Atmel - Anleitung
   * AVR121: Enhancing ADC resolution by oversampling
   */
  adval += analogRead(pin_stromsensor);
  adval += analogRead(pin_stromsensor);
  adval += analogRead(pin_stromsensor);
  adval += analogRead(pin_stromsensor);
  adval = adval >> 1;
  if(adval<205)adval=205;
  unsigned int current_measure = map(adval, 205, 2048, 0, isensorMaxmA);      //Ausgangsspannung bei 0A errechnet sich aus Vcc*0.1  - Ausgehend von 5V Vcc wäre der Messwert bei 0A also 204,8 (205)
  
  /* Folgender Block errechnet die verbrauchten Milliampere pro 10tel Sekunde.
   * Überschreitet die Summe dann einen Wert der 1mAh entspricht, wird dieser Wert der Summe abgezogen und der mAh-Zähler um 1 erhöht
   * 1mAh = 36000mA/10stel
   */
   
  intervall = millis() - last_currentcheck;
  mahHighRes+=(current_measure*intervall)/10;         //Errechnet mA/10tel Sekunde
  last_currentcheck = millis();
  
  while(mahHighRes >= 36000) {                        //Umrechnen und Addieren auf den mAh-Zähler
   sensorValues.mah++;
   mahHighRes-=36000; 
  }
  
  /* Berechnen der verbleibenen Kapazität in Prozent.
   * Hierbei müssen wir den Fehler ausschließen, dass der Setup-Wert des Akkus kleiner ist als der Akku eigentlich ist und somit mehr
   * Kapazität entnommen werden kann als angegeben. Differenzrechnung würde einen Negativen Wert ermitteln der nicht in die Variable passt.
   */
  if(settings.akku_size>=sensorValues.mah)
    sensorValues.percent = 100-(sensorValues.mah*100)/settings.akku_size;    //Errechnet die verbleibenen Prozent der Akkukapazität
  else
    sensorValues.percent = 0;  //Eventuell wurde mehr entnommen als der Akku groß sein sollte (falscher Wert im Setup)
}


//--------------------------------------------------------------------------------


void readVoltage() {
  //Spannung aus dem Maximalwert (für den der Spannungsteiler ausgelegt wurde) und dem aktuellen Messwert errechnen,
  sensorValues.voltage = map(analogRead(pin_gesamtspannung),0,1023,0,abs_max_vin);//  (abs_max_vin/1023)*analogRead(pin_gesamtspannung);
}


//--------------------------------------------------------------------------------


void draw(void) {
  glcd.clear();
  switch(state){
     case state_default:             screen_main();             break;
     case state_penter:              state=state_ptimer;        break;
     //case state_preset:            screen_menu("Reset Akku"); break;
     case state_ptimer:              screen_menu("Timer");      break;
     case state_psetup:              screen_menu("Setup");      break;
     case state_pinfo:               screen_menu("Info");       break;
     case state_pback:               screen_menu("Zurueck");    break;
     case state_info:                screen_info();             break;
          
     case state_senter:              prepare_setup();  state=state_smaxtemp;      break;
     case state_smaxtemp:            screen_smaxtemp();         break;
     case state_shyster:             screen_shyster();          break;
     case state_sakkutype:           screen_sakkutype();        break;
     case state_sakkucapa:           screen_sakkucapa();        break;
     case state_sakkucut:            screen_sakkucut();         break;
     case state_sakkudowarn:         screen_sakkudowarn();      break;
     case state_sakkuwarn:           screen_sakkuwarn();        break;
     case state_sheatpause:          screen_sheatpause();       break;
     case state_sheatpauseduration:  screen_sheatpauseduration();       break;
     case state_sfanduration:        screen_sfanduration();     break;
     case state_sfanpause:           screen_sfanpause();        break;
     case state_ssetbacklight:       screen_ssetbacklight();    break;
    // case state_ssetcontrast:        screen_ssetcontrast();     break;
     case state_sstoreeeprom:        screen_sstoreeprom();      break;
     case state_ssavesettings:       screen_ssavesettings();    break;
     case state_sback:               if(save_settings)store_setup();else reset_setup(); state=state_penter;        break;
       
     case state_showreset:           resetAkku();               break;        //Rechnet die bereits gehaltene Zeit in Bezug auf die akkuResetDelay in Teile von Hundert um (Wert kann direkt der screen-Methode übergeben werden)
  }
  glcd.display();
}


//--------------------------------------------------------------------------------

void resetAkku(){
  /* Solange der Reset-Button gehalten wird, wird der "Fortschrittsbalken" angezeigt und aktualisiert.
   * Nach Erreichen der Haltezeit werden alle Akkuwerte zurückgesetzt und die Methode zum Schreiben in den EEPROM
   * aufgerufen.
   */
   
   
  uint16_t val =  ((millis()-bounceTime)*100) / akkuResetDelay;   
  if(val < 100) {
    beep(0);
    screen_holdReset(val);
  }
  else {
    screen_akkuReset();
    glcd.display();
    beep(1);
    delay(2000);
    mahHighRes=0;
    sensorValues.mah=0;
    sensorValues.percent=100;
    state=state_default;
    writeCapa();          //Werte in den EEPROM schreiben
  }
}

//--------------------------------------------------------------------------------


void store_setup() {
  screen_settingsSaved();
  settings=temp_settings;
  eepromWriteSettings();        //Struct Settings ins EEPRom speichern
  delay(2000);
  save_settings=false;
}

void reset_setup() {
  analogWrite(pin_backgroundled,settings.backlight);
}


//--------------------------------------------------------------------------------


void prepare_setup(){
  temp_settings = settings;
}

//--------------------------------------------------------------------------------

void isr_button0(){
  if (abs(millis() - bounceTime) > button_debounce) {
     if(digitalRead(pin_left) == 0) {
       if(buttonIsPressed)return;          //Bereits ein anderer Button gedrückt -> dann machen wir hier nichts.
       currentButton = pin_left;
       buttonIsPressed = true;             //Merken, dass ein Button gedrückt wurde
       buttonHandler(true,false);
     } else {
       buttonIsPressed = false;
       buttonHandler(false,false);
     }
     bounceTime = millis();  // set whatever bounce time in ms is appropriate
 }
}


void isr_button1(){
  if (abs(millis() - bounceTime) > button_debounce) {
     //if(!buttonIsPressed) {
     if(digitalRead(pin_enter) == 0) {
       if(buttonIsPressed)return;          //Bereits ein anderer Button gedrückt -> dann machen wir hier nichts.
       currentButton = pin_enter;
       buttonIsPressed = true;             //Merken, dass ein Button gedrückt wurde
       buttonHandler(true,false);
     } else {
       buttonIsPressed = false;
       buttonHandler(false,false);
     }
     bounceTime = millis();  // set whatever bounce time in ms is appropriate
 }
}


void isr_button2(){
  if (abs(millis() - bounceTime) > button_debounce) {
     if(digitalRead(pin_right) == 0) {
       if(buttonIsPressed)return;          //Bereits ein anderer Button gedrückt -> dann machen wir hier nichts.
       currentButton = pin_right;
       buttonIsPressed = true;             //Merken, dass ein Button gedrückt wurde
       buttonHandler(true,false);
     } else {
       buttonIsPressed = false;
     }
     bounceTime = millis();  // set whatever bounce time in ms is appropriate
     buttonHandler(false,false);
 }
}


//--------------------------------------------------------------------------------


void buttonHandler(boolean pressed, boolean longpress){

  if(state==state_default) {                                         //Default-Screen
    if(!pressed || longpress) return;
    
    switch(currentButton){
      case pin_enter:  state=state_penter; break;
      case pin_left:   state=state_showreset; break;
      case pin_right:  return;
    }
    beep(0);
  }
  
  else
  if(state==state_showreset){
    if(!pressed) state=state_default;
  }
  
  else 
  if(state>=state_penter && state <= state_pback) {                  //Premenu-Bereich
     if(!pressed || longpress) return;
      beep(0);
      switch(currentButton){
        case pin_enter: loadNext();  break;
        case pin_left:  if(state > state_penter){state--;} if(state == state_penter){state = state_pback;}     break;
        case pin_right: if(state <= state_pback){state++;} if(state > state_pback)  {state = state_penter+1;}  break;
      }
      //if(state == state_penter){state = state_pback-1;};
      //if(state == state_pback) {state = state_penter+1;};
  }
    
  else
  if(state>=state_senter && state <= state_sback) {                  //Setup-Bereich
    if(!pressed) return;
    beep(0);
    switch(currentButton){
      case pin_enter: if(state < state_sback)state++;  break;
      case pin_left:  changeSValue(longpress?2:0);   break;
      case pin_right: changeSValue(longpress?3:1);   break;
    }
  }
  else state = state_default;                                        //Für den Fall dass irgend etwas schief gelaufen ist->Zurück zur Übersicht
}

//--------------------------------------------------------------------------------


void changeSValue(byte dir){
  /* Verändert den zum Menü passenden Wert. 
   * Der Wert in "dir" beinhaltet die Aussage über Richtung und Geschwindigkeit:
   * 0000000xB    das erste Bit sagt über die Richtung aus (1= höher, 0=tiefer)
   * 000000x0B    das zweite Bit sagt über die Geschwindigkeit aus(1=schneller, 0 = normal)
   */
  switch(state){
     case state_smaxtemp:    if(dir==0  &&     temp_settings.max_temp>abs_min_temp) temp_settings.max_temp-=default_slow_step;
                             else if(dir==1 && temp_settings.max_temp<abs_max_temp) temp_settings.max_temp+=default_slow_step; 
                             else if(dir==2 && temp_settings.max_temp>abs_min_temp) temp_settings.max_temp-=default_fast_step;
                             else if(dir==3 && temp_settings.max_temp<abs_max_temp) temp_settings.max_temp+=default_fast_step;
                             break;
                             
     case state_shyster:     if(dir==0  &&     temp_settings.hysterese>abs_min_hysterese) temp_settings.hysterese-=default_slow_step;
                             else if(dir==1 && temp_settings.hysterese<abs_max_hysterese) temp_settings.hysterese+=default_slow_step;
                             else if(dir==2 && temp_settings.hysterese>abs_min_hysterese) temp_settings.hysterese-=default_fast_step;
                             else if(dir==3 && temp_settings.hysterese<abs_max_hysterese) temp_settings.hysterese+=default_fast_step;
                             break;
                             
     case state_sakkutype:   if(dir==0  &&     temp_settings.akku_type>0)                 temp_settings.akku_type--;
                             else if(dir==1 && temp_settings.akku_type<countAkkuTypes-2)  temp_settings.akku_type++;
                             break;
                             
     case state_sakkucapa:   if(dir==0  &&     temp_settings.akku_size>0)                 temp_settings.akku_size-=capa_slow_step;
                             else if(dir==1 && temp_settings.akku_size<abs_max_batt)      temp_settings.akku_size+=capa_slow_step;
                             else if(dir==2 && temp_settings.akku_size>0)                 temp_settings.akku_size-=capa_fast_step;
                             else if(dir==3 && temp_settings.akku_size<abs_max_batt)      temp_settings.akku_size+=capa_fast_step;
                             break;
                             
     case state_sakkucut:    if(dir==0  &&     temp_settings.akku_cut>0)                  temp_settings.akku_cut-=capa_slow_step;
                             else if(dir==1 && temp_settings.akku_cut<temp_settings.akku_size)  temp_settings.akku_cut+=capa_slow_step;
                             else if(dir==2 && temp_settings.akku_cut>0)                  temp_settings.akku_cut-=capa_fast_step;
                             else if(dir==3 && temp_settings.akku_cut<temp_settings.akku_size)  temp_settings.akku_cut+=capa_fast_step;
                             break;
                             
     case state_sakkudowarn: if(temp_settings.do_akkuwarn)temp_settings.do_akkuwarn=false;
                             else temp_settings.do_akkuwarn=true;
                             break;
     
     case state_sakkuwarn:   if(dir==0  &&     temp_settings.akku_warn>0)                 temp_settings.akku_warn-=capa_slow_step;
                             else if(dir==1 && temp_settings.akku_warn<temp_settings.akku_cut)   temp_settings.akku_warn+=capa_slow_step;
                             else if(dir==2 && temp_settings.akku_warn>0)                 temp_settings.akku_warn-=capa_fast_step;
                             else if(dir==3 && temp_settings.akku_warn<temp_settings.akku_cut)   temp_settings.akku_warn+=capa_fast_step;
                             break;
     
     case state_sheatpause:  if(dir==0  &&     temp_settings.heat_pause>abs_min_heatpause) temp_settings.heat_pause-=default_slow_step;
                             else if(dir==1 && temp_settings.heat_pause<abs_max_heatpause) temp_settings.heat_pause+=default_slow_step;
                             else if(dir==2 && temp_settings.heat_pause>abs_min_heatpause) temp_settings.heat_pause-=default_fast_step;
                             else if(dir==3 && temp_settings.heat_pause<abs_max_heatpause) temp_settings.heat_pause+=default_fast_step;
                             break;
                             
     case state_sheatpauseduration:  if(dir==0  &&     temp_settings.heat_pauseduration>abs_min_heatpauseduration) temp_settings.heat_pauseduration-=default_slow_step;
                             else if(dir==1 && temp_settings.heat_pauseduration<abs_max_heatpauseduration) temp_settings.heat_pauseduration+=default_slow_step;
                             else if(dir==2 && temp_settings.heat_pauseduration>abs_min_heatpauseduration) temp_settings.heat_pauseduration-=default_fast_step;
                             else if(dir==3 && temp_settings.heat_pauseduration<abs_max_heatpauseduration) temp_settings.heat_pauseduration+=default_fast_step;
                             break;   
                          
                             
     case state_sfanduration:if(dir==0  &&     temp_settings.fan_duration>abs_min_fanduration) temp_settings.fan_duration-=default_slow_step;
                             else if(dir==1 && temp_settings.fan_duration<abs_max_fanduration) temp_settings.fan_duration+=default_slow_step;
                             else if(dir==2 && temp_settings.fan_duration>abs_min_fanduration) temp_settings.fan_duration-=default_fast_step;
                             else if(dir==3 && temp_settings.fan_duration<abs_max_fanduration) temp_settings.fan_duration+=default_fast_step;
                             break;
                             
     case state_sfanpause:   if(dir==0  &&     temp_settings.fan_pause>abs_min_fanpause) temp_settings.fan_pause-=default_slow_step;
                             else if(dir==1 && temp_settings.fan_pause<abs_max_fanpause) temp_settings.fan_pause+=default_slow_step;
                             else if(dir==2 && temp_settings.fan_pause>abs_min_fanpause) temp_settings.fan_pause-=default_fast_step;
                             else if(dir==3 && temp_settings.fan_pause<abs_max_fanpause) temp_settings.fan_pause+=default_fast_step;
                             break;
                             
     case state_ssetbacklight:   if(dir==0  && temp_settings.backlight>abs_min_backlight) temp_settings.backlight-=default_slow_step;
                             else if(dir==1 && temp_settings.backlight<abs_max_backlight) temp_settings.backlight+=default_slow_step;
                             else if(dir==2 && temp_settings.backlight>abs_min_backlight) temp_settings.backlight-=default_fast_step;
                             else if(dir==3 && temp_settings.backlight<abs_max_backlight) temp_settings.backlight+=default_fast_step;
                             break;
 /*
     case state_ssetcontrast:   if(dir==0  &&  temp_settings.contrast>abs_min_contrast) temp_settings.contrast-=default_slow_step;
                             else if(dir==1 && temp_settings.contrast<abs_max_contrast) temp_settings.contrast+=default_slow_step;
                             else if(dir==2 && temp_settings.contrast>abs_min_contrast) temp_settings.contrast-=default_fast_step;
                             else if(dir==3 && temp_settings.contrast<abs_max_contrast) temp_settings.contrast+=default_fast_step;
                             break;
 */
                             
     
     case state_sstoreeeprom:if(temp_settings.storeEEPROM)temp_settings.storeEEPROM=false;
                             else temp_settings.storeEEPROM=true;
                             break;
                             
     case state_ssavesettings:if(save_settings)save_settings=false;
                             else save_settings=true;
                             break; 
  }//switch
  
  /* Werte korregieren
   *
   */
   
   if(temp_settings.max_temp>abs_max_temp) temp_settings.max_temp=abs_max_temp;
   if(temp_settings.max_temp<abs_min_temp) temp_settings.max_temp=abs_min_temp;
   
   if(temp_settings.hysterese>abs_max_hysterese) temp_settings.hysterese=abs_max_hysterese;
   if(temp_settings.hysterese<abs_min_hysterese) temp_settings.hysterese=abs_min_hysterese;
   
   if(temp_settings.akku_type>=countAkkuTypes) temp_settings.akku_type=countAkkuTypes-1;
   //if(temp_settings.akku_type<0) temp_settings.akku_type=0    //kann nicht passieren da Datentyp=Byte
   
   if(temp_settings.akku_size>abs_max_batt) temp_settings.akku_size=abs_max_batt;
   //if(temp_settings.akku_size<0) temp_settings.akku_size=0;    //kann nicht passieren da Datentyp=Unsigned
   
   if(temp_settings.akku_cut>temp_settings.akku_size) temp_settings.akku_cut=temp_settings.akku_size;
   //if(temp_settings.akku_cut<0) temp_settings.akku_cut=0;    //kann nicht passieren da Datentyp=Unsigned
   
   if(temp_settings.akku_warn>temp_settings.akku_cut) temp_settings.akku_warn=temp_settings.akku_cut;
   //if(temp_settings.akku_warn<0) temp_settings.akku_warn=0;    //kann nicht passieren da Datentyp=Unsigned
   
   if(temp_settings.heat_pause>abs_max_heatpause) temp_settings.heat_pause=abs_max_heatpause;
   if(temp_settings.heat_pause<abs_min_heatpause) temp_settings.heat_pause=abs_min_heatpause;

   if(temp_settings.heat_pauseduration>abs_max_heatpauseduration) temp_settings.heat_pauseduration=abs_max_heatpauseduration;
   if(temp_settings.heat_pauseduration<abs_min_heatpauseduration) temp_settings.heat_pauseduration=abs_min_heatpauseduration;

   if(temp_settings.fan_duration>abs_max_fanduration) temp_settings.fan_duration=abs_max_fanduration;
   if(temp_settings.fan_duration<abs_min_fanduration) temp_settings.fan_duration=abs_min_fanduration;   

   if(temp_settings.fan_pause>abs_max_fanpause) temp_settings.fan_pause=abs_max_fanpause;
   if(temp_settings.fan_pause<abs_min_fanpause) temp_settings.fan_pause=abs_min_fanpause;
   
   if(temp_settings.backlight>abs_max_backlight) temp_settings.backlight=abs_max_backlight;
   if(temp_settings.backlight<abs_min_backlight) temp_settings.backlight=abs_min_backlight;
   
   //if(temp_settings.contrast>abs_max_contrast) temp_settings.contrast=abs_max_contrast;
   //if(temp_settings.contrast<abs_min_contrast) temp_settings.contrast=abs_min_contrast;
   
   analogWrite(pin_backgroundled,display_backlight_values[temp_settings.backlight]);
   //glcd.uc1601_set_brightness(temp_settings.contrast);
}


//--------------------------------------------------------------------------------


void loadNext(){
   switch(state){
     case state_psetup: state=state_senter;       break;
     //case state_preset: state=state_confirmreset; break;
     case state_ptimer: state=state_timermenu;    break;
     case state_pinfo:  state=state_info;         break;
     case state_pback:  state=state_default;      break;
   }
}


//--------------------------------------------------------------------------------

